/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.Location;
import sedonac.ast.IncludeDef;
import sedonac.ast.TypeDef;
import sedonac.ir.IrKit;
import sedonac.namespace.Type;
import sedonac.parser.Parser;
import sedonac.steps.ResolveDepends;

public class ResolveIncludes
extends ResolveDepends {
    public void run() {
        IncludeDef[] includeDefArray = this.compiler.ast.includes;
        if (includeDefArray == null || includeDefArray.length == 0) {
            this.compiler.ast.types = new TypeDef[0];
            return;
        }
        this.log.debug("  ResolveIncludes");
        int n = 0;
        while (n < includeDefArray.length) {
            includeDefArray[n].sourceKit = this.resolveDepend(includeDefArray[n]);
            ++n;
        }
        this.quitIfErrors();
        n = 0;
        while (n < includeDefArray.length) {
            IrKit irKit = includeDefArray[n].sourceKit;
            this.resolveRecursive(irKit, null);
            if (irKit.manifest.hasNatives) {
                this.err("Cannot include types from kits that have natives: " + irKit.file);
            }
            ++n;
        }
        this.quitIfErrors();
        ArrayList arrayList = new ArrayList(includeDefArray.length);
        int n2 = 0;
        while (n2 < includeDefArray.length) {
            this.autoInclude(includeDefArray[n2]);
            this.resolveTypes(includeDefArray[n2], arrayList);
            ++n2;
        }
        this.quitIfErrors();
        this.compiler.ast.types = arrayList.toArray(new TypeDef[arrayList.size()]);
    }

    private final void autoInclude(IncludeDef includeDef) {
        Set set = includeDef.typeToSource.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        int n = 0;
        while (n < stringArray.length) {
            this.recursivelyAutoInclude(includeDef, stringArray[n]);
            ++n;
        }
    }

    private final void recursivelyAutoInclude(IncludeDef includeDef, String string) {
        Type type = includeDef.sourceKit.type(string);
        if (type == null) {
            return;
        }
        Type type2 = type.base();
        int n = -1;
        n = type2.qname().indexOf(58);
        String string2 = type2.qname().substring(0, n);
        String string3 = type2.qname().substring(n + 2);
        if (string2.equals(includeDef.depend.name()) && !includeDef.typeToSource.containsKey(string3)) {
            StringBuffer stringBuffer = new StringBuffer().append("Auto-Including '").append(type2.toString()).append("' from kit ").append(includeDef.sourceKit.file).append(". '").append(string).append("' depends on it.");
            this.warn(stringBuffer.toString());
            includeDef.typeToSource.put(string3, null);
            this.recursivelyAutoInclude(includeDef, string3);
        }
    }

    private final void resolveTypes(IncludeDef includeDef, ArrayList arrayList) {
        File file = includeDef.sourceKit.file.file;
        Location location = null;
        try {
            TypeDef[] typeDefArray;
            Object object;
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (((ZipEntry)object).isDirectory() || !((ZipEntry)object).getName().endsWith(".sedona")) continue;
                bl = true;
                location = new Location(file, (ZipEntry)object);
                typeDefArray = new Parser(this.compiler, location, zipFile.getInputStream((ZipEntry)object)).parse();
                int n = 0;
                while (n < typeDefArray.length) {
                    if (includeDef.typeToSource.containsKey(typeDefArray[n].name())) {
                        includeDef.typeToSource.put(typeDefArray[n].name(), object);
                        arrayList.add(typeDefArray[n]);
                        this.log.debug("      Include '" + typeDefArray[n].name() + "' from: " + file.getName() + '|' + ((ZipEntry)object).getName());
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.err("<include> error: Kit '" + includeDef.sourceKit.name() + "' does not include source files.");
            }
            object = includeDef.typeToSource.keySet().iterator();
            while (object.hasNext()) {
                typeDefArray = (TypeDef[])object.next();
                if (includeDef.typeToSource.get(typeDefArray) != null) continue;
                this.err("<include> error: type '" + (String)typeDefArray + "' was not defined in any source files from kit '" + includeDef.sourceKit.file + '\'');
            }
            zipFile.close();
        }
        catch (CompilerException compilerException) {
            throw this.err("Failed to compile source from kit", location, (Throwable)compilerException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.err("Cannot import types from kit file", new Location(file), (Throwable)exception);
        }
    }

    public ResolveIncludes(Compiler compiler) {
        super(compiler);
        this.autoMountKitIntoNamespace = false;
    }
}

